% !TeX root = TechSciencePaper.tex
%% LaTeX2e file `techscience.cls'
% Document class for publication in techscience
% LaTeX2e version 4.0 2000
% 
% Copyleft 2006
%
% Standard Disclaimer Applies.
%

\ProvidesClass{techscience}[2007/01/28]
\NeedsTeXFormat{LaTeX2e}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\PassOptionsToClass{11pt}{book}
\PassOptionsToClass{fleqn}{book}
\ProcessOptions
\LoadClass{book}

\ifx\pdfoutput\undefined
  \RequirePackage[dvips]{graphicx}
  \RequirePackage[dvips]{geometry}
\else
  \RequirePackage[pdftex]{graphicx}
  \DeclareGraphicsExtensions{.pdf,.png,.jpg,.mps}
  \RequirePackage[pdftex]{geometry}
\fi

%\geometry{papersize={7in,10in},total={5in,7.5in},hmarginratio=1:1,vmarginratio=1:1}
\geometry{papersize={21.59cm,27.94cm},top=2.54cm,bottom=2.54cm,left=2.54cm,right=2.54cm,headsep=.82cm}%,showframe
\RequirePackage{amsmath,amsfonts,amssymb}
\RequirePackage[latin1]{inputenc}
\RequirePackage[T1]{fontenc}
\RequirePackage{enumerate}
%\RequirePackage{textcomp}
\RequirePackage{microtype}
\RequirePackage[colorlinks=true,linkcolor=blue!50!cyan,urlcolor=black]{hyperref}
\RequirePackage{enumitem}
\RequirePackage{float}
\RequirePackage{indentfirst}
\RequirePackage{booktabs}
 \RequirePackage{tikz}
 \RequirePackage{calc}
 \RequirePackage{amsthm}
 \RequirePackage{enumitem}
 \RequirePackage{setspace}
 \RequirePackage{multirow}
 \RequirePackage{mathptmx}
 \RequirePackage{mdframed}
 \RequirePackage{fancyhdr}
 \RequirePackage{tcolorbox}
 \RequirePackage{tcolorbox}
 \RequirePackage{tabularx,colortbl}
 \RequirePackage[hang,flushmargin]{footmisc}
\RequirePackage{xparse}
\RequirePackage{verbatim}
\RequirePackage{indentfirst}
\RequirePackage{url}
\urlstyle{same}
\RequirePackage{threeparttable}
\RequirePackage{ifthen}
%\RequirePackage{natbib}
\RequirePackage{subfigure}
\RequirePackage{bm}
\setlength{\mathindent}{0em}
\gdef\pindent{0em}
\setlength\parindent{\pindent}
\setlength\abovecaptionskip{0\p@}
\setlength\belowcaptionskip{0\p@}
\setlength\parskip{3pt}
\setlength\footnotesep{7.7pt}
\setcounter{totalnumber}{5}
\setcounter{secnumdepth}{3}
\setcounter{tocdepth}{3}
\setcounter{topnumber}{5}
\renewcommand\topfraction{.7}
\renewcommand\textfraction{.2}
\setlength\floatsep    {10\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\textfloatsep{10\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {10\p@ \@plus 4\p@ \@minus 4\p@}
\belowcaptionskip=4pt
\abovedisplayskip 5\p@ \@plus2\p@ \@minus5\p@
\abovedisplayshortskip \z@ \@plus3\p@
\belowdisplayshortskip 3\p@ \@plus3\p@ \@minus3\p@


\renewcommand\normalsize{%
   \@setfontsize\normalsize\@xipt{13.6}%
   \abovedisplayskip 5.5\p@ \@plus3\p@ \@minus3\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6.5\p@ \@plus3.5\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\RequirePackage[labelfont=bf,skip=2pt]{caption}%

\newcommand{\addbottompattern}{
  \begin{tikzpicture}[remember picture,overlay]
    \fill[gray!20] (current page.south west) rectangle (current page.south east);
    \node[rotate=45,gray!50,scale=5] at (current page.center) {\textbf{For review}};
  \end{tikzpicture}
}


%
%  bottom-of-page footnotes format
%  full width line and hanging indent
%

\def\footnoterule{\kern-3\p@
 \hrule width .45\columnwidth \kern 2.6\p@}
\long\def\@makefntext#1{\parindent=1em\hangindent=1em \def\baselinestretch{1.0}
\noindent\hbox to1em{\hss$^{\@thefnmark}$\,}\ignorespaces #1}
\def\@makefnmark{\hbox{\@textsuperscript{{\fontsize{6pt}{6pt}\selectfont\@thefnmark}}}}%\bfseries
%
% page style
%
\pagestyle{empty}
\pagestyle{myheadings}\markboth{}{}
\pagenumbering{arabic}
\setcounter{section}{0}

\def\ps@titleheadings{%
    \def\@evenhead{}%
    \def\@oddhead{}%
    \def\@oddfoot{\fontsize{9pt}{13.5pt}\selectfont\@licensefoot\hfill }%\footnotesize %%
    \let\@evenfoot\@oddfoot%
    \let\@mkboth\@gobbletwo
    \let\chaptermark\@gobble
    \let\sectionmark\@gobble
    }

	
%  heading
%
%\def\ps@myheadings{%
%    \let\@oddfoot\@empty\let\@evenfoot\@empty
%    \def\@evenhead{\thepage\hfil\ \ \leftmark}%
%    \def\@oddhead{{\rightmark}\hfil\thepage}%
%    \let\@mkboth\@gobbletwo
%    \let\chaptermark\@gobble
%    \let\sectionmark\@gobble
%    }
\def\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\thepage\hfil\ \ \@citeself}% \leftmark
    \def\@oddhead{{\rightmark}\hfil\thepage}% \itshape
    \let\@mkboth\@gobbletwo
    \let\chaptermark\@gobble
    \let\sectionmark\@gobble
    }
\newcommand {\markhead}[1]  {\gdef\thishead{#1}}
\newcommand {\markthishead} {%
\pagestyle{myheadings}%
\markboth{\mbox{\fontsize{10pt}{15pt}\selectfont\thepage}\hfill{\fontsize{10pt}{15pt}\selectfont\@citeself}}%\@copyright \underline
{{\fontsize{10pt}{15pt}\@citeself}\hfill}}%\underline\@runningtitle


\def\appendix{
 \setcounter{section}{0}
 \def\thesection{Appendix \Alph{section}:}
}
\def\@seccntformat#1{\csname the#1\endcsname\ }
\renewcommand\section{%
 \@startsection {section}{1}{\z@}%
      {-2.3ex \@plus -1ex \@minus -.2ex}%
	  {0.04ex \@plus .1ex}%{0.1ex \@plus .1ex}
      {\reset@font\fontsize{11pt}{11pt}\selectfont \bfseries\upshape}}%
\renewcommand\subsection{%
 \@startsection{subsection}{2}{\z@}%
      {-1.65ex\@plus -1ex \@minus -.2ex}%
      {0.08ex \@plus .2ex}%{0.8ex \@plus .2ex}
      {\reset@font\normalsize\bfseries\itshape}}%
\renewcommand\subsubsection{%
 \@startsection{subsubsection}{3}{\z@}%
      {-1.45ex\@plus -1ex \@minus -.2ex}%
      {0.08ex \@plus .2ex}%{0.8ex \@plus .2ex}
      {\reset@font\normalsize\mdseries\itshape}}

\renewcommand{\theequation}{\arabic{equation}}
\renewcommand{\thesection}{\arabic{section}}
\renewcommand{\thefigure}{\arabic{figure}}
\renewcommand{\thetable}{\arabic{table}}

\newcommand{\fig}[1]{Fig.~\ref{#1}}
\newcommand{\tab}[1]{Tab.~\ref{#1}}
\newcommand{\eq}[1]{Eq.~\ref{#1}}


%
%  Bibliography
\let\mycite\cite
\renewcommand\cite[1]{\index{#1}\mycite{#1}}


\renewcommand\maketitle{\par
 \def\@firstpg{\pageref{firstpg}}
 \def\@lastpg{\pageref{lastpg}}
 \markthishead
 \label{firstpg}
 \begingroup
   \if@twocolumn
     \ifnum \col@number=\@ne
       \@maketitle
     \else
       \twocolumn[\@maketitle]%
     \fi
   \else
     \newpage
     \global\@topnum\z@   % Prevents figures from going at top of page.
     \@maketitle
   \fi
   \thispagestyle{titleheadings}\@thanks
 \endgroup
 \setcounter{footnote}{2}%
 \global\let\thanks\relax
 \global\let\maketitle\relax
 \global\let\@maketitle\relax
 \global\let\@thanks\@empty
 \@firstpage
 \global\let\@author\@empty
 \global\let\@date\@empty
 \global\let\@title\@empty
 \global\let\title\relax
 \global\let\author\relax
 \global\let\date\relax
 \global\let\and\relax
}
%\def\@maketitle{%
% \newpage
% \thispagestyle{empty}
% \null
% \vskip -2.5em%
% \mbox{\small\@copyright}\hfill{\small\@citeself}
% \null
% \vskip 4em%
% \begin{center}%
% \let \footnote \thanks
%   {\textbf{\fontsize{14pt}{19pt}\selectfont \@title} \par}%
%   %\vskip 1.5em%
%   { \lineskip .5em%
%     %\begin{tabular}[t]{c}%
%       \fontsize{10pt}{19pt}\selectfont \textbf{\@author}
%     %\end{tabular}
%     \par}%
%   \vskip 2em%
%   %{\large \@date}%
% \end{center}%
% \par}


\renewcommand{\thanks}[1]{\footnote{\raggedright#1}}
\def\@maketitle{%
	\newpage
	\thispagestyle{empty}
	\null
	\vskip -2.5em%
%	\mbox{\hspace{-4ex}\itshape\bfseries\the\thehead}\hfill{\newline DOI:xxxxx
	\mbox{\hspace{-4ex}\itshape\the\thehead}\hfill{
	\vspace{-6pt}\hspace{1cm} \includegraphics[width=4.0cm,height=0.55cm]{techscience} \hspace{0.1cm}
\rule{\textwidth}{0.4pt}%
    \newline	
	\footnotesize{DOI: 10.32604/journal.202x.0xxxxx} \hfill
	\newline

	\noindent\textbf{\underline{TYPE of the PAPER}}}%\@copyright\@citeself
	\null	
	\begin{center}%
		\begin{minipage}{\textwidth}
				\vskip 0.35cm%
					%\makeatletter% need xpatch
			%\makeatother
			%\let \footnote \thanks
			\setlength{\footnotesep}{0.40cm}
			\raggedright
			%\let\thanks\footnote
			\renewcommand*\footnoterule{}
			\renewcommand{\thempfootnote}{\arabic{mpfootnote}}
			\renewcommand{\footnotesize}{\fontsize{9pt}{9pt}\selectfont}
			{\bfseries\fontsize{14pt}{19pt}\selectfont \@title} \par
			\vskip 0.4cm
			{\bfseries\fontsize{11pt}{19pt}\selectfont \@author}\par %
			\vskip 0.45cm%
			\end{minipage}
		\end{center}%
	\par}


%%%%%%%%
\renewenvironment{thebibliography}[1]
    {\section*{References}%
     \list{\@arabic\c@enumiv.~~}%
          {\settowidth\labelwidth{\@biblabel{#1}}%
           \leftmargin\labelwidth
    \setlength\labelsep{0ex}
    \setlength\parsep{0ex}
    \setlength\itemsep{0ex}
           \advance\leftmargin\labelsep
           \@openbib@code
           \usecounter{enumiv}%
           \let\p@enumiv\@empty
           \renewcommand\theenumiv{\@arabic\c@enumiv}}%
     \sloppy
     \clubpenalty4000
     \@clubpenalty \clubpenalty
     \widowpenalty4000%
     \sfcode`\.\@m}
    {\def\@noitemerr
      {\@latex@warning{Empty `thebibliography' environment}}%
     \endlist}


%%%%%%%%
\gdef\runningtitle#1{\gdef\@runningtitle{#1}}
\gdef\doi#1{\gdef\@doifoot{#1}}
\gdef\license#1{\gdef\@licensefoot{#1}} 
\gdef\@runtitle{}
\gdef\citeself#1{\gdef\@citeself{#1}}
\gdef\@copyright{Copyright \copyright \ \@techscienceyear\ Tech Science Press}
\gdef\@citeself{RIMNI, \@techscienceyear, \@techsciencevol, \@techscienceno}%pp.\@firstpg-\@lastpg vol.  no.
\gdef\techsciencevol#1{\gdef\@techsciencevol{#1}}
\gdef\techscienceno#1{\gdef\@techscienceno{#1}}
\gdef\techscienceyear#1{\gdef\@techscienceyear{#1}}
\gdef\@techsciencevol{}
\gdef\@techscienceno{}
\gdef\@techscienceyear{}
%\gdef\@lastpg{}
%\gdef\@firstpg{}
\gdef\techscience#1#2#3#4{\techsciencevol{#1}\techscienceno{#2}\techscienceyear{#3}\setcounter{page}{#4}}
\gdef\ignore#1{}



%%%%%%%%
% .tit file
% 1. title/author info for the generation of table of contents
% 2. page number of the last page for the page numbering of next page

\def\@maketitleauthor{%
 \newwrite\@titleauthorfile
 \immediate\openout\@titleauthorfile=\jobname.tit
 \def\titleauthor{\@bsphack\begingroup
               \@sanitize
               \@wrtitleauthor}\typeout
   {Writing title/author info. \jobname.tit }%
 \let\maketitleauthor\@empty
}
\def\@wrtitleauthor#1#2{%
  \protected@write\@titleauthorfile{}%
     {#1 #2 {\thepage}}%
 \endgroup
 \@esphack}
\@maketitleauthor



%%%%%%%%
% 1. step the page counter to the first page
% 2. put author/title info into .tit
% 3. .tit to be used for the generation of table of contents.
% 4. propagate vol, no, year.

\def\@firstpage{%
 \stepcounter{page}\label{firstpg}%
 \global\let\affiliate\relax
 \titleauthor{\string\tocline}{{\@title} {\@author}}%
 \titleauthor{\string\techsciencevol}{{\@techsciencevol} \string\ignore}%
 \titleauthor{\string\techscienceno}{{\@techscienceno} \string\ignore}%
 \titleauthor{\string\techscienceyear}{{\@techscienceyear} \string\ignore}%
 }
\def\tocline#1#2#3{}
\def\techsciencekey#1#2{}
\def\techscienceabs#1#2{}


%%%%%%%%
% 1. ensure the paper ends in even page number.
% 2. save the page number in .tit for as the starting point for the
%    next paper.  (.tit will be included at the begin of the next paper)
 \RequirePackage{ifthen}
\def\lastpage{%
  \label{lastpg}%
  \ifthenelse{\isodd{\value{page}}}{\clearpage\thispagestyle{empty}\ }{}%
  \titleauthor{\string\prevpage}{}%
  }
\def\prevpage#1{\setcounter{page}{#1}}



%%%%%%%%Proof watermark
\newif\ifproof
\prooftrue
\AtBeginDocument{
\ifproof
\RequirePackage{eso-pic}
\RequirePackage{color}
  \AddToShipoutPicture{%
  \newdimen\@tempdimd \newdimen\@tempdime
    \setlength{\@tempdimb}{.5\paperwidth}%
    \setlength{\@tempdimc}{.5\paperheight}%
    \setlength{\@tempdimd}{.50\paperwidth}%
    \setlength{\@tempdime}{.98\paperheight}%
    \setlength{\unitlength}{1pt}%
    \put(\strip@pt\@tempdimd,\strip@pt\@tempdime){\textcolor[gray]{0.0}{\fontsize{11pt}{\baselineskip}\selectfont
 \textit{   }}}
    \put(\strip@pt\@tempdimb,\strip@pt\@tempdimc){%
      \makebox(0,0){\rotatebox{60}{\textcolor[gray]{0.9}{\fontsize{8cm}{16cm}\selectfont}}}
    }
 }
 \else
  \titleauthor{\string\prooffalse}{\string\ignore}%
 \fi
}


%%%%%%%%superscript for authors
\def\affiliate#1{\fontsize{9pt}{9pt}\selectfont$^{\bm#1}$}%
\newtoks\thehead

\ExplSyntaxOn%


%%%%%%%%
\NewDocumentEnvironment {abstract}{}{
	\par\vskip-0.2cm
	\vspace{6pt}\leftskip0in\relax\rightskip0in\relax\setlength\parindent{0in}\fontsize{10pt}{12pt}\selectfont\textbf{Abstract:}
}{
	\par\leftskip0cm\relax\rightskip0cm\relax
}
\NewDocumentCommand \keywords { m } {
	\par\vskip-0.2cm
	\vspace{12pt}\leftskip0in\relax\rightskip0in\relax\setlength\parindent{0in}\fontsize{10pt}{12pt}\textbf{Keywords:~}\\
          \selectfont#1}


%%%%%%%%
\NewDocumentCommand \acknowledge { m }{
	\vskip 2.3ex%
	\hspace{-0.28in}\textbf{Acknowledgement:~}#1\par
}

\NewDocumentCommand \funding{ m }{
	\vskip 2.3ex%
	\hspace{-0.28in}\textbf{Funding\ Statement:~}#1\par
}

\NewDocumentCommand \Contribution{ m }{
	\vskip 2.3ex%
	\hspace{-0.28in}\textbf{Author\ Contributions:~}#1\par
}

\NewDocumentCommand \Data{ m }{
	\vskip 2.3ex%
	\hspace{-0.28in}\textbf{Availability\ of\ Data\ and\ Materials:~}#1\par
}

\NewDocumentCommand \Ethics{ m }{
	\vskip 2.3ex%
	\hspace{-0.28in}\textbf{Ethics\ Approval:~}#1\par
}

\NewDocumentCommand \interest{ m }{
	\vskip 2.3ex%
	\hspace{-0.28in}\textbf{Conflicts\ of\ Interest:~}#1\par
}

\NewDocumentCommand \Supplementary{ m }{
	\vskip 2.3ex%
	\hspace{-0.28in}\textbf{Supplementary\ Materials:~}#1\par
}



\newcounter{ttspappendix}
\NewDocumentCommand \tspappendix { m }{
	\vskip 0.5ex
	\stepcounter{ttspappendix}\par
	{\hspace{-0.28in}\bfseries Appendix~\Alph{ttspappendix}~#1}\par}

\ExplSyntaxOff

%%%% Maths environments
\RequirePackage{amsthm}
\newtheoremstyle{tsp}% name
{12pt}% space above
{12pt}% space below
{\itshape}% body font
{}% indent amount 1
{\bfseries}% theorem head font
{.}% punctuation after theorem head
{.5em}% space after theorem head
{}% theorem head spec (can be left empty, meaning `normal')

\renewcommand{\qed}{\unskip\nobreak\quad\qedsymbol} %% This places the symbol right after the text instead of placing it at the end on the line.

\renewenvironment{proof}[1][\proofname]{\par %% \proofname allows to have "Proof of my theorem"
  \pushQED{\qed}%
  \normalfont \topsep6\p@\@plus6\p@\relax
  \trivlist
  \item[\hskip\labelsep
        \bfseries %% "Proof" is bold
    #1\@addpunct{.}]\ignorespaces %% Period instead of colon
}{%
  \popQED\endtrivlist\@endpefalse
}

 \theoremstyle{tsp}
 \newcounter{theorem}
 \setcounter{theorem}{0}
 \newtheorem{Theorem}[theorem]{Theorem}
 
 \newcounter{lemma}
 \setcounter{lemma}{0}
 \newtheorem{Lemma}[lemma]{Lemma}
 
 \newcounter{corollary}
 \setcounter{corollary}{0}
 \newtheorem{Corollary}[corollary]{Corollary}
 
 \newcounter{proposition}
 \setcounter{proposition}{0}
 \newtheorem{Proposition}[proposition]{Proposition}
 
 \newcounter{characterization}
 \setcounter{characterization}{0}
 \newtheorem{Characterization}[characterization]{Characterization}
 
 \newcounter{property}
 \setcounter{property}{0}
 \newtheorem{Property}[property]{Property}
 
 \newcounter{problem}
 \setcounter{problem}{0}
 \newtheorem{Problem}[problem]{Problem}
 
 \newcounter{example}
 \setcounter{example}{0}
 \newtheorem{Example}[example]{Example}
 
 \newcounter{examplesanddefinitions}
 \setcounter{examplesanddefinitions}{0}
 \newtheorem{ExamplesandDefinitions}[examplesanddefinitions]{Examples and Definitions}
 
 \newcounter{remark}
 \setcounter{remark}{0}
 \newtheorem{Remark}[remark]{Remark}
 
 \newcounter{definition}
 \setcounter{definition}{0}
 \newtheorem{Definition}[definition]{Definition}
 
 \newcounter{hypothesis}
 \setcounter{hypothesis}{0}
 \newtheorem{Hypothesis}[hypothesis]{Hypothesis}

 \newcounter{notation}
 \setcounter{notation}{0}
 \newtheorem{Notation}[notation]{Notation}
 
 \newcounter{assumption}
 \setcounter{assumption}{0}
 \newtheorem{Assumption}[assumption]{Assumption}
 
 \newcounter{algorithm}
 \setcounter{algorithm}{0}
 \newtheorem{Algorithm}[algorithm]{Algorithm}
 
 % Define left/right mark in math environment
\let\originalleft\left
\let\originalright\right
\renewcommand{\left}{\mathopen{}\mathclose\bgroup\originalleft}
\renewcommand{\right}{\aftergroup\egroup\originalright}

%  you may need \affiliate{1} for two different author in the same affiliation.
% $^\star {}^\ast{}^{\bm ,}$ %\useackage{MnSymbol}\rotatebox{12}{$^\ast$}
% \textsuperscript{\bfseries ,*}
